/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.UserActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserActivityRequest;
import java.util.List;

public class UserActivityRequest
extends BaseRequest
implements IUserActivityRequest {
    public UserActivityRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivity.class);
    }

    @Override
    public void get(ICallback<UserActivity> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public UserActivity get() throws ClientException {
        return (UserActivity)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<UserActivity> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(UserActivity sourceUserActivity, ICallback<UserActivity> callback) {
        this.send(HttpMethod.PATCH, callback, sourceUserActivity);
    }

    @Override
    public UserActivity patch(UserActivity sourceUserActivity) throws ClientException {
        return (UserActivity)this.send(HttpMethod.PATCH, sourceUserActivity);
    }

    @Override
    public void post(UserActivity newUserActivity, ICallback<UserActivity> callback) {
        this.send(HttpMethod.POST, callback, newUserActivity);
    }

    @Override
    public UserActivity post(UserActivity newUserActivity) throws ClientException {
        return (UserActivity)this.send(HttpMethod.POST, newUserActivity);
    }

    @Override
    public void put(UserActivity newUserActivity, ICallback<UserActivity> callback) {
        this.send(HttpMethod.PUT, callback, newUserActivity);
    }

    @Override
    public UserActivity put(UserActivity newUserActivity) throws ClientException {
        return (UserActivity)this.send(HttpMethod.PUT, newUserActivity);
    }

    @Override
    public IUserActivityRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserActivityRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

