/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Team;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamCollectionPage;
import com.microsoft.graph.requests.extensions.TeamCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamRequestBuilder;
import java.util.List;

public class TeamCollectionRequest
extends BaseCollectionRequest<TeamCollectionResponse, ITeamCollectionPage>
implements ITeamCollectionRequest {
    public TeamCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamCollectionResponse.class, ITeamCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamCollectionPage get() throws ClientException {
        TeamCollectionResponse response = (TeamCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Team newTeam, ICallback<Team> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeam, callback);
    }

    @Override
    public Team post(Team newTeam) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeam);
    }

    @Override
    public ITeamCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITeamCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITeamCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITeamCollectionPage buildFromResponse(TeamCollectionResponse response) {
        TeamCollectionRequestBuilder builder = response.nextLink != null ? new TeamCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamCollectionPage page = new TeamCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

