/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.SiteCollectionResponse;
import com.microsoft.graph.requests.extensions.SiteWithReferenceRequestBuilder;
import java.util.List;

public class SiteCollectionReferenceRequest
extends BaseCollectionRequest<SiteCollectionResponse, ISiteCollectionPage>
implements ISiteCollectionReferenceRequest {
    public SiteCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteCollectionResponse.class, ISiteCollectionPage.class);
    }

    @Override
    public void post(Site newSite, ICallback<Site> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/sites/" + newSite.id);
        new SiteWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSite, body, callback);
    }

    @Override
    public Site post(Site newSite) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/sites/" + newSite.id);
        return new SiteWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSite, body);
    }

    public ISiteCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISiteCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

