/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SiteAddBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteAddCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteAddCollectionRequest;
import com.microsoft.graph.requests.extensions.SiteAddCollectionPage;
import com.microsoft.graph.requests.extensions.SiteAddCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SiteAddCollectionResponse;
import java.util.List;

public class SiteAddCollectionRequest
extends BaseCollectionRequest<SiteAddCollectionResponse, ISiteAddCollectionPage>
implements ISiteAddCollectionRequest {
    protected final SiteAddBody body = new SiteAddBody();

    public SiteAddCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteAddCollectionResponse.class, ISiteAddCollectionPage.class);
    }

    @Override
    public void post(final ICallback<ISiteAddCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SiteAddCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteAddCollectionPage post() throws ClientException {
        SiteAddCollectionResponse response = (SiteAddCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public ISiteAddCollectionPage buildFromResponse(SiteAddCollectionResponse response) {
        SiteAddCollectionRequestBuilder builder = response.nextLink != null ? new SiteAddCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        SiteAddCollectionPage page = new SiteAddCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ISiteAddCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteAddCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISiteAddCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

