/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SchemaExtension;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISchemaExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.ISchemaExtensionCollectionRequest;
import com.microsoft.graph.requests.extensions.SchemaExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.SchemaExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SchemaExtensionCollectionResponse;
import com.microsoft.graph.requests.extensions.SchemaExtensionRequestBuilder;
import java.util.List;

public class SchemaExtensionCollectionRequest
extends BaseCollectionRequest<SchemaExtensionCollectionResponse, ISchemaExtensionCollectionPage>
implements ISchemaExtensionCollectionRequest {
    public SchemaExtensionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SchemaExtensionCollectionResponse.class, ISchemaExtensionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISchemaExtensionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SchemaExtensionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISchemaExtensionCollectionPage get() throws ClientException {
        SchemaExtensionCollectionResponse response = (SchemaExtensionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(SchemaExtension newSchemaExtension, ICallback<SchemaExtension> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSchemaExtension, callback);
    }

    @Override
    public SchemaExtension post(SchemaExtension newSchemaExtension) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new SchemaExtensionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newSchemaExtension);
    }

    @Override
    public ISchemaExtensionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ISchemaExtensionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ISchemaExtensionCollectionPage buildFromResponse(SchemaExtensionCollectionResponse response) {
        SchemaExtensionCollectionRequestBuilder builder = response.nextLink != null ? new SchemaExtensionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SchemaExtensionCollectionPage page = new SchemaExtensionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

