/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MobileAppAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMobileAppAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.IMobileAppAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentRequestBuilder;
import java.util.List;

public class MobileAppAssignmentCollectionRequest
extends BaseCollectionRequest<MobileAppAssignmentCollectionResponse, IMobileAppAssignmentCollectionPage>
implements IMobileAppAssignmentCollectionRequest {
    public MobileAppAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppAssignmentCollectionResponse.class, IMobileAppAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMobileAppAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MobileAppAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMobileAppAssignmentCollectionPage get() throws ClientException {
        MobileAppAssignmentCollectionResponse response = (MobileAppAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MobileAppAssignment newMobileAppAssignment, ICallback<MobileAppAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MobileAppAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppAssignment, callback);
    }

    @Override
    public MobileAppAssignment post(MobileAppAssignment newMobileAppAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MobileAppAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMobileAppAssignment);
    }

    @Override
    public IMobileAppAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMobileAppAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMobileAppAssignmentCollectionPage buildFromResponse(MobileAppAssignmentCollectionResponse response) {
        MobileAppAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new MobileAppAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MobileAppAssignmentCollectionPage page = new MobileAppAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

