/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ManagedAppOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IManagedAppOperationCollectionPage;
import com.microsoft.graph.requests.extensions.IManagedAppOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedAppOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.ManagedAppOperationRequestBuilder;
import java.util.List;

public class ManagedAppOperationCollectionRequest
extends BaseCollectionRequest<ManagedAppOperationCollectionResponse, IManagedAppOperationCollectionPage>
implements IManagedAppOperationCollectionRequest {
    public ManagedAppOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppOperationCollectionResponse.class, IManagedAppOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IManagedAppOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ManagedAppOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IManagedAppOperationCollectionPage get() throws ClientException {
        ManagedAppOperationCollectionResponse response = (ManagedAppOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ManagedAppOperation newManagedAppOperation, ICallback<ManagedAppOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ManagedAppOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppOperation, callback);
    }

    @Override
    public ManagedAppOperation post(ManagedAppOperation newManagedAppOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ManagedAppOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newManagedAppOperation);
    }

    @Override
    public IManagedAppOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IManagedAppOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IManagedAppOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IManagedAppOperationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IManagedAppOperationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IManagedAppOperationCollectionPage buildFromResponse(ManagedAppOperationCollectionResponse response) {
        ManagedAppOperationCollectionRequestBuilder builder = response.nextLink != null ? new ManagedAppOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ManagedAppOperationCollectionPage page = new ManagedAppOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

