/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.IosUpdateDeviceStatus;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIosUpdateDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IIosUpdateDeviceStatusCollectionRequest;
import com.microsoft.graph.requests.extensions.IosUpdateDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.IosUpdateDeviceStatusCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IosUpdateDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.IosUpdateDeviceStatusRequestBuilder;
import java.util.List;

public class IosUpdateDeviceStatusCollectionRequest
extends BaseCollectionRequest<IosUpdateDeviceStatusCollectionResponse, IIosUpdateDeviceStatusCollectionPage>
implements IIosUpdateDeviceStatusCollectionRequest {
    public IosUpdateDeviceStatusCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IosUpdateDeviceStatusCollectionResponse.class, IIosUpdateDeviceStatusCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IIosUpdateDeviceStatusCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(IosUpdateDeviceStatusCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IIosUpdateDeviceStatusCollectionPage get() throws ClientException {
        IosUpdateDeviceStatusCollectionResponse response = (IosUpdateDeviceStatusCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(IosUpdateDeviceStatus newIosUpdateDeviceStatus, ICallback<IosUpdateDeviceStatus> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new IosUpdateDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIosUpdateDeviceStatus, callback);
    }

    @Override
    public IosUpdateDeviceStatus post(IosUpdateDeviceStatus newIosUpdateDeviceStatus) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new IosUpdateDeviceStatusRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newIosUpdateDeviceStatus);
    }

    @Override
    public IIosUpdateDeviceStatusCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IIosUpdateDeviceStatusCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIosUpdateDeviceStatusCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IIosUpdateDeviceStatusCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IIosUpdateDeviceStatusCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IIosUpdateDeviceStatusCollectionPage buildFromResponse(IosUpdateDeviceStatusCollectionResponse response) {
        IosUpdateDeviceStatusCollectionRequestBuilder builder = response.nextLink != null ? new IosUpdateDeviceStatusCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        IosUpdateDeviceStatusCollectionPage page = new IosUpdateDeviceStatusCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

