/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.InferenceClassificationOverride;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IInferenceClassificationOverrideCollectionPage;
import com.microsoft.graph.requests.extensions.IInferenceClassificationOverrideCollectionRequest;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionPage;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideCollectionResponse;
import com.microsoft.graph.requests.extensions.InferenceClassificationOverrideRequestBuilder;
import java.util.List;

public class InferenceClassificationOverrideCollectionRequest
extends BaseCollectionRequest<InferenceClassificationOverrideCollectionResponse, IInferenceClassificationOverrideCollectionPage>
implements IInferenceClassificationOverrideCollectionRequest {
    public InferenceClassificationOverrideCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, InferenceClassificationOverrideCollectionResponse.class, IInferenceClassificationOverrideCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IInferenceClassificationOverrideCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(InferenceClassificationOverrideCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IInferenceClassificationOverrideCollectionPage get() throws ClientException {
        InferenceClassificationOverrideCollectionResponse response = (InferenceClassificationOverrideCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(InferenceClassificationOverride newInferenceClassificationOverride, ICallback<InferenceClassificationOverride> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newInferenceClassificationOverride, callback);
    }

    @Override
    public InferenceClassificationOverride post(InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new InferenceClassificationOverrideRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newInferenceClassificationOverride);
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IInferenceClassificationOverrideCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IInferenceClassificationOverrideCollectionPage buildFromResponse(InferenceClassificationOverrideCollectionResponse response) {
        InferenceClassificationOverrideCollectionRequestBuilder builder = response.nextLink != null ? new InferenceClassificationOverrideCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        InferenceClassificationOverrideCollectionPage page = new InferenceClassificationOverrideCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

