/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EventDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.EventDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EventDeltaCollectionResponse;
import com.microsoft.graph.requests.extensions.IEventDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IEventDeltaCollectionRequest;
import java.util.List;

public class EventDeltaCollectionRequest
extends BaseCollectionRequest<EventDeltaCollectionResponse, IEventDeltaCollectionPage>
implements IEventDeltaCollectionRequest {
    public EventDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EventDeltaCollectionResponse.class, IEventDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IEventDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EventDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEventDeltaCollectionPage get() throws ClientException {
        EventDeltaCollectionResponse response = (EventDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IEventDeltaCollectionPage buildFromResponse(EventDeltaCollectionResponse response) {
        EventDeltaCollectionRequestBuilder builder = response.nextLink != null ? new EventDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EventDeltaCollectionPage page = new EventDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IEventDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEventDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEventDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

