/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DeviceComplianceScheduledActionForRule;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleRequestBuilder;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleCollectionPage;
import com.microsoft.graph.requests.extensions.IDeviceComplianceScheduledActionForRuleCollectionRequest;
import java.util.List;

public class DeviceComplianceScheduledActionForRuleCollectionRequest
extends BaseCollectionRequest<DeviceComplianceScheduledActionForRuleCollectionResponse, IDeviceComplianceScheduledActionForRuleCollectionPage>
implements IDeviceComplianceScheduledActionForRuleCollectionRequest {
    public DeviceComplianceScheduledActionForRuleCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceScheduledActionForRuleCollectionResponse.class, IDeviceComplianceScheduledActionForRuleCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDeviceComplianceScheduledActionForRuleCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DeviceComplianceScheduledActionForRuleCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionPage get() throws ClientException {
        DeviceComplianceScheduledActionForRuleCollectionResponse response = (DeviceComplianceScheduledActionForRuleCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DeviceComplianceScheduledActionForRule newDeviceComplianceScheduledActionForRule, ICallback<DeviceComplianceScheduledActionForRule> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DeviceComplianceScheduledActionForRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceScheduledActionForRule, callback);
    }

    @Override
    public DeviceComplianceScheduledActionForRule post(DeviceComplianceScheduledActionForRule newDeviceComplianceScheduledActionForRule) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DeviceComplianceScheduledActionForRuleRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDeviceComplianceScheduledActionForRule);
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDeviceComplianceScheduledActionForRuleCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDeviceComplianceScheduledActionForRuleCollectionPage buildFromResponse(DeviceComplianceScheduledActionForRuleCollectionResponse response) {
        DeviceComplianceScheduledActionForRuleCollectionRequestBuilder builder = response.nextLink != null ? new DeviceComplianceScheduledActionForRuleCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DeviceComplianceScheduledActionForRuleCollectionPage page = new DeviceComplianceScheduledActionForRuleCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

