/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Contract;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ContractCollectionPage;
import com.microsoft.graph.requests.extensions.ContractCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ContractCollectionResponse;
import com.microsoft.graph.requests.extensions.ContractRequestBuilder;
import com.microsoft.graph.requests.extensions.IContractCollectionPage;
import com.microsoft.graph.requests.extensions.IContractCollectionRequest;
import java.util.List;

public class ContractCollectionRequest
extends BaseCollectionRequest<ContractCollectionResponse, IContractCollectionPage>
implements IContractCollectionRequest {
    public ContractCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ContractCollectionResponse.class, IContractCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IContractCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ContractCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IContractCollectionPage get() throws ClientException {
        ContractCollectionResponse response = (ContractCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Contract newContract, ICallback<Contract> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ContractRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newContract, callback);
    }

    @Override
    public Contract post(Contract newContract) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ContractRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newContract);
    }

    @Override
    public IContractCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IContractCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IContractCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IContractCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IContractCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IContractCollectionPage buildFromResponse(ContractCollectionResponse response) {
        ContractCollectionRequestBuilder builder = response.nextLink != null ? new ContractCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ContractCollectionPage page = new ContractCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

