/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Application;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IApplicationRequest;
import java.util.List;

public class ApplicationRequest
extends BaseRequest
implements IApplicationRequest {
    public ApplicationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Application.class);
    }

    @Override
    public void get(ICallback<Application> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Application get() throws ClientException {
        return (Application)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Application> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Application sourceApplication, ICallback<Application> callback) {
        this.send(HttpMethod.PATCH, callback, sourceApplication);
    }

    @Override
    public Application patch(Application sourceApplication) throws ClientException {
        return (Application)this.send(HttpMethod.PATCH, sourceApplication);
    }

    @Override
    public void post(Application newApplication, ICallback<Application> callback) {
        this.send(HttpMethod.POST, callback, newApplication);
    }

    @Override
    public Application post(Application newApplication) throws ClientException {
        return (Application)this.send(HttpMethod.POST, newApplication);
    }

    @Override
    public void put(Application newApplication, ICallback<Application> callback) {
        this.send(HttpMethod.PUT, callback, newApplication);
    }

    @Override
    public Application put(Application newApplication) throws ClientException {
        return (Application)this.send(HttpMethod.PUT, newApplication);
    }

    @Override
    public IApplicationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IApplicationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

