/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Alert;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AlertCollectionPage;
import com.microsoft.graph.requests.extensions.AlertCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AlertCollectionResponse;
import com.microsoft.graph.requests.extensions.AlertRequestBuilder;
import com.microsoft.graph.requests.extensions.IAlertCollectionPage;
import com.microsoft.graph.requests.extensions.IAlertCollectionRequest;
import java.util.List;

public class AlertCollectionRequest
extends BaseCollectionRequest<AlertCollectionResponse, IAlertCollectionPage>
implements IAlertCollectionRequest {
    public AlertCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AlertCollectionResponse.class, IAlertCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IAlertCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AlertCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAlertCollectionPage get() throws ClientException {
        AlertCollectionResponse response = (AlertCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Alert newAlert, ICallback<Alert> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAlert, callback);
    }

    @Override
    public Alert post(Alert newAlert) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AlertRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAlert);
    }

    @Override
    public IAlertCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAlertCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAlertCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAlertCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAlertCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAlertCollectionPage buildFromResponse(AlertCollectionResponse response) {
        AlertCollectionRequestBuilder builder = response.nextLink != null ? new AlertCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AlertCollectionPage page = new AlertCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

