/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ActivityHistoryItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionPage;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemCollectionResponse;
import com.microsoft.graph.requests.extensions.ActivityHistoryItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemCollectionPage;
import com.microsoft.graph.requests.extensions.IActivityHistoryItemCollectionRequest;
import java.util.List;

public class ActivityHistoryItemCollectionRequest
extends BaseCollectionRequest<ActivityHistoryItemCollectionResponse, IActivityHistoryItemCollectionPage>
implements IActivityHistoryItemCollectionRequest {
    public ActivityHistoryItemCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ActivityHistoryItemCollectionResponse.class, IActivityHistoryItemCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IActivityHistoryItemCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ActivityHistoryItemCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IActivityHistoryItemCollectionPage get() throws ClientException {
        ActivityHistoryItemCollectionResponse response = (ActivityHistoryItemCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ActivityHistoryItem newActivityHistoryItem, ICallback<ActivityHistoryItem> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newActivityHistoryItem, callback);
    }

    @Override
    public ActivityHistoryItem post(ActivityHistoryItem newActivityHistoryItem) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ActivityHistoryItemRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newActivityHistoryItem);
    }

    @Override
    public IActivityHistoryItemCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IActivityHistoryItemCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IActivityHistoryItemCollectionPage buildFromResponse(ActivityHistoryItemCollectionResponse response) {
        ActivityHistoryItemCollectionRequestBuilder builder = response.nextLink != null ? new ActivityHistoryItemCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ActivityHistoryItemCollectionPage page = new ActivityHistoryItemCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

