/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.NotebookLinks;
import com.microsoft.graph.models.extensions.OnenoteEntityHierarchyModel;
import com.microsoft.graph.models.extensions.OnenoteSection;
import com.microsoft.graph.models.extensions.SectionGroup;
import com.microsoft.graph.models.generated.OnenoteUserRole;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionPage;
import com.microsoft.graph.requests.extensions.OnenoteSectionCollectionResponse;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionPage;
import com.microsoft.graph.requests.extensions.SectionGroupCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;

public class Notebook
extends OnenoteEntityHierarchyModel
implements IJsonBackedObject {
    @SerializedName(value="isDefault")
    @Expose
    public Boolean isDefault;
    @SerializedName(value="isShared")
    @Expose
    public Boolean isShared;
    @SerializedName(value="links")
    @Expose
    public NotebookLinks links;
    @SerializedName(value="sectionGroupsUrl")
    @Expose
    public String sectionGroupsUrl;
    @SerializedName(value="sectionsUrl")
    @Expose
    public String sectionsUrl;
    @SerializedName(value="userRole")
    @Expose
    public OnenoteUserRole userRole;
    @SerializedName(value="sectionGroups")
    @Expose
    public SectionGroupCollectionPage sectionGroups;
    @SerializedName(value="sections")
    @Expose
    public OnenoteSectionCollectionPage sections;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        OnenoteEntityHierarchyModel[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("sectionGroups")) {
            response = new SectionGroupCollectionResponse();
            if (json.has("sectionGroups@odata.nextLink")) {
                response.nextLink = json.get("sectionGroups@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("sectionGroups").toString(), JsonObject[].class);
            array = new SectionGroup[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SectionGroup.class);
                ((SectionGroup)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.sectionGroups = new SectionGroupCollectionPage((SectionGroupCollectionResponse)response, null);
        }
        if (json.has("sections")) {
            response = new OnenoteSectionCollectionResponse();
            if (json.has("sections@odata.nextLink")) {
                ((OnenoteSectionCollectionResponse)response).nextLink = json.get("sections@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("sections").toString(), JsonObject[].class);
            array = new OnenoteSection[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), OnenoteSection.class);
                ((OnenoteSection)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((OnenoteSectionCollectionResponse)response).value = Arrays.asList(array);
            this.sections = new OnenoteSectionCollectionPage((OnenoteSectionCollectionResponse)response, null);
        }
    }
}

