// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartSeries;
import com.microsoft.graph.requests.extensions.IWorkbookChartSeriesItemAtRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesItemAtRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Series Item At Request.
 */
public class WorkbookChartSeriesItemAtRequest extends BaseRequest implements IWorkbookChartSeriesItemAtRequest {

    /**
     * The request for this WorkbookChartSeriesItemAt
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartSeriesItemAtRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WorkbookChartSeries.class);
    }

    /**
     * Patches the WorkbookChartSeriesItemAt
     * @param srcWorkbookChartSeries the WorkbookChartSeries with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    public void patch(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<WorkbookChartSeries> callback) {
        send(HttpMethod.PATCH, callback, srcWorkbookChartSeries);
    }

    /**
     * Patches the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries with which to PATCH
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     public WorkbookChartSeries patch(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException {
        return this.send(HttpMethod.PATCH, srcWorkbookChartSeries);
    }

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(WorkbookChartSeries srcWorkbookChartSeries, final ICallback<WorkbookChartSeries> callback) {
        send(HttpMethod.PUT, callback, srcWorkbookChartSeries);
    }

    /**
     * Puts the WorkbookChartSeriesItemAt
     *
     * @param srcWorkbookChartSeries the WorkbookChartSeries to PUT
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     public WorkbookChartSeries put(WorkbookChartSeries srcWorkbookChartSeries) throws ClientException {
        return this.send(HttpMethod.PUT, srcWorkbookChartSeries);
    }
    /**
     * Gets the WorkbookChartSeries
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WorkbookChartSeries> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WorkbookChartSeries
     *
     * @return the WorkbookChartSeries
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public WorkbookChartSeries get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IWorkbookChartSeriesItemAtRequest select(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
        return (WorkbookChartSeriesItemAtRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IWorkbookChartSeriesItemAtRequest expand(final String value) {
        getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (WorkbookChartSeriesItemAtRequest)this;
    }

}
