// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TimeZoneInformation;
import com.microsoft.graph.models.generated.TimeZoneStandard;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IOutlookUserSupportedTimeZonesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedTimeZonesCollectionPage;
import com.microsoft.graph.requests.extensions.OutlookUserSupportedTimeZonesCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Outlook User Supported Time Zones Collection Page.
 */
public class OutlookUserSupportedTimeZonesCollectionPage extends BaseCollectionPage<TimeZoneInformation, IOutlookUserSupportedTimeZonesCollectionRequestBuilder> implements IOutlookUserSupportedTimeZonesCollectionPage {

    /**
     * A collection page for TimeZoneInformation.
     *
     * @param response The serialized OutlookUserSupportedTimeZonesCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public OutlookUserSupportedTimeZonesCollectionPage(final OutlookUserSupportedTimeZonesCollectionResponse response, final IOutlookUserSupportedTimeZonesCollectionRequestBuilder builder) {
       super(response.value, builder);
    }
}
