// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ManagedDeviceOverview;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Overview Request.
 */
public class ManagedDeviceOverviewRequest extends BaseRequest implements IManagedDeviceOverviewRequest {
	
    /**
     * The request for the ManagedDeviceOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceOverviewRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedDeviceOverview.class);
    }

    /**
     * Gets the ManagedDeviceOverview from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<ManagedDeviceOverview> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ManagedDeviceOverview from the service
     *
     * @return the ManagedDeviceOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<ManagedDeviceOverview> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedDeviceOverview with a source
     *
     * @param sourceManagedDeviceOverview the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ManagedDeviceOverview sourceManagedDeviceOverview, final ICallback<ManagedDeviceOverview> callback) {
        send(HttpMethod.PATCH, callback, sourceManagedDeviceOverview);
    }

    /**
     * Patches this ManagedDeviceOverview with a source
     *
     * @param sourceManagedDeviceOverview the source object with updates
     * @return the updated ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceOverview patch(final ManagedDeviceOverview sourceManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ManagedDeviceOverview newManagedDeviceOverview, final ICallback<ManagedDeviceOverview> callback) {
        send(HttpMethod.POST, callback, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the new object to create
     * @return the created ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceOverview post(final ManagedDeviceOverview newManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.POST, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ManagedDeviceOverview newManagedDeviceOverview, final ICallback<ManagedDeviceOverview> callback) {
        send(HttpMethod.PUT, callback, newManagedDeviceOverview);
    }

    /**
     * Creates a ManagedDeviceOverview with a new object
     *
     * @param newManagedDeviceOverview the object to create/update
     * @return the created ManagedDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedDeviceOverview put(final ManagedDeviceOverview newManagedDeviceOverview) throws ClientException {
        return send(HttpMethod.PUT, newManagedDeviceOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IManagedDeviceOverviewRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ManagedDeviceOverviewRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IManagedDeviceOverviewRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ManagedDeviceOverviewRequest)this;
     }

}

