// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ManagedAppStatus;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed App Status Request.
 */
public class ManagedAppStatusRequest extends BaseRequest implements IManagedAppStatusRequest {
	
    /**
     * The request for the ManagedAppStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public ManagedAppStatusRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends ManagedAppStatus> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the ManagedAppStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedAppStatusRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ManagedAppStatus.class);
    }

    /**
     * Gets the ManagedAppStatus from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<ManagedAppStatus> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ManagedAppStatus from the service
     *
     * @return the ManagedAppStatus from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedAppStatus get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<ManagedAppStatus> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ManagedAppStatus with a source
     *
     * @param sourceManagedAppStatus the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ManagedAppStatus sourceManagedAppStatus, final ICallback<ManagedAppStatus> callback) {
        send(HttpMethod.PATCH, callback, sourceManagedAppStatus);
    }

    /**
     * Patches this ManagedAppStatus with a source
     *
     * @param sourceManagedAppStatus the source object with updates
     * @return the updated ManagedAppStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedAppStatus patch(final ManagedAppStatus sourceManagedAppStatus) throws ClientException {
        return send(HttpMethod.PATCH, sourceManagedAppStatus);
    }

    /**
     * Creates a ManagedAppStatus with a new object
     *
     * @param newManagedAppStatus the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ManagedAppStatus newManagedAppStatus, final ICallback<ManagedAppStatus> callback) {
        send(HttpMethod.POST, callback, newManagedAppStatus);
    }

    /**
     * Creates a ManagedAppStatus with a new object
     *
     * @param newManagedAppStatus the new object to create
     * @return the created ManagedAppStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedAppStatus post(final ManagedAppStatus newManagedAppStatus) throws ClientException {
        return send(HttpMethod.POST, newManagedAppStatus);
    }

    /**
     * Creates a ManagedAppStatus with a new object
     *
     * @param newManagedAppStatus the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ManagedAppStatus newManagedAppStatus, final ICallback<ManagedAppStatus> callback) {
        send(HttpMethod.PUT, callback, newManagedAppStatus);
    }

    /**
     * Creates a ManagedAppStatus with a new object
     *
     * @param newManagedAppStatus the object to create/update
     * @return the created ManagedAppStatus
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ManagedAppStatus put(final ManagedAppStatus newManagedAppStatus) throws ClientException {
        return send(HttpMethod.PUT, newManagedAppStatus);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IManagedAppStatusRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ManagedAppStatusRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IManagedAppStatusRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ManagedAppStatusRequest)this;
     }

}

