// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookRangeSort;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Range Sort Request.
 */
public interface IWorkbookRangeSortRequest extends IHttpRequest {

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookRangeSort> callback);

    /**
     * Gets the WorkbookRangeSort from the service
     *
     * @return the WorkbookRangeSort from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeSort get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookRangeSort> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookRangeSort sourceWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback);

    /**
     * Patches this WorkbookRangeSort with a source
     *
     * @param sourceWorkbookRangeSort the source object with updates
     * @return the updated WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeSort patch(final WorkbookRangeSort sourceWorkbookRangeSort) throws ClientException;

    /**
     * Posts a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookRangeSort newWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback);

    /**
     * Posts a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the new object to create
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeSort post(final WorkbookRangeSort newWorkbookRangeSort) throws ClientException;

    /**
     * Posts a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookRangeSort newWorkbookRangeSort, final ICallback<WorkbookRangeSort> callback);

    /**
     * Posts a WorkbookRangeSort with a new object
     *
     * @param newWorkbookRangeSort the object to create/update
     * @return the created WorkbookRangeSort
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookRangeSort put(final WorkbookRangeSort newWorkbookRangeSort) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookRangeSortRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookRangeSortRequest expand(final String value);

}

