// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookCommentReply;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Comment Reply Request.
 */
public interface IWorkbookCommentReplyRequest extends IHttpRequest {

    /**
     * Gets the WorkbookCommentReply from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookCommentReply> callback);

    /**
     * Gets the WorkbookCommentReply from the service
     *
     * @return the WorkbookCommentReply from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookCommentReply get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookCommentReply> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookCommentReply with a source
     *
     * @param sourceWorkbookCommentReply the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookCommentReply sourceWorkbookCommentReply, final ICallback<WorkbookCommentReply> callback);

    /**
     * Patches this WorkbookCommentReply with a source
     *
     * @param sourceWorkbookCommentReply the source object with updates
     * @return the updated WorkbookCommentReply
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookCommentReply patch(final WorkbookCommentReply sourceWorkbookCommentReply) throws ClientException;

    /**
     * Posts a WorkbookCommentReply with a new object
     *
     * @param newWorkbookCommentReply the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookCommentReply newWorkbookCommentReply, final ICallback<WorkbookCommentReply> callback);

    /**
     * Posts a WorkbookCommentReply with a new object
     *
     * @param newWorkbookCommentReply the new object to create
     * @return the created WorkbookCommentReply
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookCommentReply post(final WorkbookCommentReply newWorkbookCommentReply) throws ClientException;

    /**
     * Posts a WorkbookCommentReply with a new object
     *
     * @param newWorkbookCommentReply the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookCommentReply newWorkbookCommentReply, final ICallback<WorkbookCommentReply> callback);

    /**
     * Posts a WorkbookCommentReply with a new object
     *
     * @param newWorkbookCommentReply the object to create/update
     * @return the created WorkbookCommentReply
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookCommentReply put(final WorkbookCommentReply newWorkbookCommentReply) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookCommentReplyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookCommentReplyRequest expand(final String value);

}

