// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TokenLifetimePolicy;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Token Lifetime Policy Request.
 */
public interface ITokenLifetimePolicyRequest extends IHttpRequest {

    /**
     * Gets the TokenLifetimePolicy from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<TokenLifetimePolicy> callback);

    /**
     * Gets the TokenLifetimePolicy from the service
     *
     * @return the TokenLifetimePolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TokenLifetimePolicy get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<TokenLifetimePolicy> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TokenLifetimePolicy with a source
     *
     * @param sourceTokenLifetimePolicy the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TokenLifetimePolicy sourceTokenLifetimePolicy, final ICallback<TokenLifetimePolicy> callback);

    /**
     * Patches this TokenLifetimePolicy with a source
     *
     * @param sourceTokenLifetimePolicy the source object with updates
     * @return the updated TokenLifetimePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TokenLifetimePolicy patch(final TokenLifetimePolicy sourceTokenLifetimePolicy) throws ClientException;

    /**
     * Posts a TokenLifetimePolicy with a new object
     *
     * @param newTokenLifetimePolicy the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TokenLifetimePolicy newTokenLifetimePolicy, final ICallback<TokenLifetimePolicy> callback);

    /**
     * Posts a TokenLifetimePolicy with a new object
     *
     * @param newTokenLifetimePolicy the new object to create
     * @return the created TokenLifetimePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TokenLifetimePolicy post(final TokenLifetimePolicy newTokenLifetimePolicy) throws ClientException;

    /**
     * Posts a TokenLifetimePolicy with a new object
     *
     * @param newTokenLifetimePolicy the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TokenLifetimePolicy newTokenLifetimePolicy, final ICallback<TokenLifetimePolicy> callback);

    /**
     * Posts a TokenLifetimePolicy with a new object
     *
     * @param newTokenLifetimePolicy the object to create/update
     * @return the created TokenLifetimePolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TokenLifetimePolicy put(final TokenLifetimePolicy newTokenLifetimePolicy) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITokenLifetimePolicyRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITokenLifetimePolicyRequest expand(final String value);

}

