// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Domain;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Domain Request.
 */
public interface IDomainRequest extends IHttpRequest {

    /**
     * Gets the Domain from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<Domain> callback);

    /**
     * Gets the Domain from the service
     *
     * @return the Domain from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Domain get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<Domain> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Domain with a source
     *
     * @param sourceDomain the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Domain sourceDomain, final ICallback<Domain> callback);

    /**
     * Patches this Domain with a source
     *
     * @param sourceDomain the source object with updates
     * @return the updated Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Domain patch(final Domain sourceDomain) throws ClientException;

    /**
     * Posts a Domain with a new object
     *
     * @param newDomain the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Domain newDomain, final ICallback<Domain> callback);

    /**
     * Posts a Domain with a new object
     *
     * @param newDomain the new object to create
     * @return the created Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Domain post(final Domain newDomain) throws ClientException;

    /**
     * Posts a Domain with a new object
     *
     * @param newDomain the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Domain newDomain, final ICallback<Domain> callback);

    /**
     * Posts a Domain with a new object
     *
     * @param newDomain the object to create/update
     * @return the created Domain
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Domain put(final Domain newDomain) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDomainRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDomainRequest expand(final String value);

}

