// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;

import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IDirectoryObjectCheckMemberObjectsCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCheckMemberObjectsCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectCheckMemberObjectsCollectionResponse;
import com.microsoft.graph.models.extensions.DirectoryObjectCheckMemberObjectsBody;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Check Member Objects Collection Request.
 */
public class DirectoryObjectCheckMemberObjectsCollectionRequest extends BaseCollectionRequest<DirectoryObjectCheckMemberObjectsCollectionResponse, IDirectoryObjectCheckMemberObjectsCollectionPage> implements IDirectoryObjectCheckMemberObjectsCollectionRequest {


    protected final DirectoryObjectCheckMemberObjectsBody body;


    /**
     * The request for this DirectoryObjectCheckMemberObjects
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryObjectCheckMemberObjectsCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectCheckMemberObjectsCollectionResponse.class, IDirectoryObjectCheckMemberObjectsCollectionPage.class);
        body = new DirectoryObjectCheckMemberObjectsBody();
    }


    public void post(final ICallback<IDirectoryObjectCheckMemberObjectsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(post(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDirectoryObjectCheckMemberObjectsCollectionPage post() throws ClientException {
        final DirectoryObjectCheckMemberObjectsCollectionResponse response = post(body);
        return buildFromResponse(response);
    }


    public IDirectoryObjectCheckMemberObjectsCollectionPage buildFromResponse(final DirectoryObjectCheckMemberObjectsCollectionResponse response) {
        final IDirectoryObjectCheckMemberObjectsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DirectoryObjectCheckMemberObjectsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, (java.util.List<String>) null);
        } else {
            builder = null;
        }
        final IDirectoryObjectCheckMemberObjectsCollectionPage page = new DirectoryObjectCheckMemberObjectsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IDirectoryObjectCheckMemberObjectsCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (IDirectoryObjectCheckMemberObjectsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IDirectoryObjectCheckMemberObjectsCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value+""));
        return (IDirectoryObjectCheckMemberObjectsCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IDirectoryObjectCheckMemberObjectsCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (IDirectoryObjectCheckMemberObjectsCollectionRequest)this;
    }

}
