// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.generated;


/**
 * The Enum Ios Updates Install Status.
*/
public enum IosUpdatesInstallStatus
{
    /**
    * success
    */
    SUCCESS,
    /**
    * available
    */
    AVAILABLE,
    /**
    * idle
    */
    IDLE,
    /**
    * unknown
    */
    UNKNOWN,
    /**
    * device Os Higher Than Desired Os Version
    */
    DEVICE_OS_HIGHER_THAN_DESIRED_OS_VERSION,
    /**
    * shared Device User Logged In Error
    */
    SHARED_DEVICE_USER_LOGGED_IN_ERROR,
    /**
    * not Supported Operation
    */
    NOT_SUPPORTED_OPERATION,
    /**
    * install Failed
    */
    INSTALL_FAILED,
    /**
    * install Phone Call In Progress
    */
    INSTALL_PHONE_CALL_IN_PROGRESS,
    /**
    * install Insufficient Power
    */
    INSTALL_INSUFFICIENT_POWER,
    /**
    * install Insufficient Space
    */
    INSTALL_INSUFFICIENT_SPACE,
    /**
    * installing
    */
    INSTALLING,
    /**
    * download Insufficient Network
    */
    DOWNLOAD_INSUFFICIENT_NETWORK,
    /**
    * download Insufficient Power
    */
    DOWNLOAD_INSUFFICIENT_POWER,
    /**
    * download Insufficient Space
    */
    DOWNLOAD_INSUFFICIENT_SPACE,
    /**
    * download Requires Computer
    */
    DOWNLOAD_REQUIRES_COMPUTER,
    /**
    * download Failed
    */
    DOWNLOAD_FAILED,
    /**
    * downloading
    */
    DOWNLOADING,
    /**
    * For IosUpdatesInstallStatus values that were not expected from the service
    */
    UNEXPECTED_VALUE
}
