// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DeviceCompliancePolicyAssignment;
import com.microsoft.graph.models.extensions.SettingStateDeviceSummary;
import com.microsoft.graph.models.extensions.DeviceComplianceDeviceStatus;
import com.microsoft.graph.models.extensions.DeviceComplianceDeviceOverview;
import com.microsoft.graph.models.extensions.DeviceComplianceScheduledActionForRule;
import com.microsoft.graph.models.extensions.DeviceComplianceUserStatus;
import com.microsoft.graph.models.extensions.DeviceComplianceUserOverview;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceCompliancePolicyAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionResponse;
import com.microsoft.graph.requests.extensions.SettingStateDeviceSummaryCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceDeviceStatusCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceScheduledActionForRuleCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceComplianceUserStatusCollectionResponse;
import com.microsoft.graph.requests.extensions.DeviceComplianceUserStatusCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Policy.
 */
public class DeviceCompliancePolicy extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * DateTime the object was created.
     */
    @SerializedName("createdDateTime")
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Description.
     * Admin provided description of the Device Configuration.
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Display Name.
     * Admin provided name of the device configuration.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Last Modified Date Time.
     * DateTime the object was last modified.
     */
    @SerializedName("lastModifiedDateTime")
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The Version.
     * Version of the device configuration.
     */
    @SerializedName("version")
    @Expose
    public Integer version;

    /**
     * The Assignments.
     * The collection of assignments for this compliance policy.
     */
    @SerializedName("assignments")
    @Expose
    public DeviceCompliancePolicyAssignmentCollectionPage assignments;

    /**
     * The Device Setting State Summaries.
     * Compliance Setting State Device Summary
     */
    @SerializedName("deviceSettingStateSummaries")
    @Expose
    public SettingStateDeviceSummaryCollectionPage deviceSettingStateSummaries;

    /**
     * The Device Statuses.
     * List of DeviceComplianceDeviceStatus.
     */
    @SerializedName("deviceStatuses")
    @Expose
    public DeviceComplianceDeviceStatusCollectionPage deviceStatuses;

    /**
     * The Device Status Overview.
     * Device compliance devices status overview
     */
    @SerializedName("deviceStatusOverview")
    @Expose
    public DeviceComplianceDeviceOverview deviceStatusOverview;

    /**
     * The Scheduled Actions For Rule.
     * The list of scheduled action for this rule
     */
    @SerializedName("scheduledActionsForRule")
    @Expose
    public DeviceComplianceScheduledActionForRuleCollectionPage scheduledActionsForRule;

    /**
     * The User Statuses.
     * List of DeviceComplianceUserStatus.
     */
    @SerializedName("userStatuses")
    @Expose
    public DeviceComplianceUserStatusCollectionPage userStatuses;

    /**
     * The User Status Overview.
     * Device compliance users status overview
     */
    @SerializedName("userStatusOverview")
    @Expose
    public DeviceComplianceUserOverview userStatusOverview;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("assignments")) {
            final DeviceCompliancePolicyAssignmentCollectionResponse response = new DeviceCompliancePolicyAssignmentCollectionResponse();
            if (json.has("assignments@odata.nextLink")) {
                response.nextLink = json.get("assignments@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("assignments").toString(), JsonObject[].class);
            final DeviceCompliancePolicyAssignment[] array = new DeviceCompliancePolicyAssignment[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceCompliancePolicyAssignment.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            assignments = new DeviceCompliancePolicyAssignmentCollectionPage(response, null);
        }

        if (json.has("deviceSettingStateSummaries")) {
            final SettingStateDeviceSummaryCollectionResponse response = new SettingStateDeviceSummaryCollectionResponse();
            if (json.has("deviceSettingStateSummaries@odata.nextLink")) {
                response.nextLink = json.get("deviceSettingStateSummaries@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("deviceSettingStateSummaries").toString(), JsonObject[].class);
            final SettingStateDeviceSummary[] array = new SettingStateDeviceSummary[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SettingStateDeviceSummary.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            deviceSettingStateSummaries = new SettingStateDeviceSummaryCollectionPage(response, null);
        }

        if (json.has("deviceStatuses")) {
            final DeviceComplianceDeviceStatusCollectionResponse response = new DeviceComplianceDeviceStatusCollectionResponse();
            if (json.has("deviceStatuses@odata.nextLink")) {
                response.nextLink = json.get("deviceStatuses@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("deviceStatuses").toString(), JsonObject[].class);
            final DeviceComplianceDeviceStatus[] array = new DeviceComplianceDeviceStatus[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceComplianceDeviceStatus.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            deviceStatuses = new DeviceComplianceDeviceStatusCollectionPage(response, null);
        }

        if (json.has("scheduledActionsForRule")) {
            final DeviceComplianceScheduledActionForRuleCollectionResponse response = new DeviceComplianceScheduledActionForRuleCollectionResponse();
            if (json.has("scheduledActionsForRule@odata.nextLink")) {
                response.nextLink = json.get("scheduledActionsForRule@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("scheduledActionsForRule").toString(), JsonObject[].class);
            final DeviceComplianceScheduledActionForRule[] array = new DeviceComplianceScheduledActionForRule[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceComplianceScheduledActionForRule.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            scheduledActionsForRule = new DeviceComplianceScheduledActionForRuleCollectionPage(response, null);
        }

        if (json.has("userStatuses")) {
            final DeviceComplianceUserStatusCollectionResponse response = new DeviceComplianceUserStatusCollectionResponse();
            if (json.has("userStatuses@odata.nextLink")) {
                response.nextLink = json.get("userStatuses@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("userStatuses").toString(), JsonObject[].class);
            final DeviceComplianceUserStatus[] array = new DeviceComplianceUserStatus[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), DeviceComplianceUserStatus.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            userStatuses = new DeviceComplianceUserStatusCollectionPage(response, null);
        }
    }
}
