/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Teamwork;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamworkRequest;
import java.util.List;

public class TeamworkRequest
extends BaseRequest
implements ITeamworkRequest {
    public TeamworkRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Teamwork.class);
    }

    @Override
    public void get(ICallback<Teamwork> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Teamwork get() throws ClientException {
        return (Teamwork)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<Teamwork> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Teamwork sourceTeamwork, ICallback<Teamwork> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTeamwork);
    }

    @Override
    public Teamwork patch(Teamwork sourceTeamwork) throws ClientException {
        return (Teamwork)this.send(HttpMethod.PATCH, sourceTeamwork);
    }

    @Override
    public void post(Teamwork newTeamwork, ICallback<Teamwork> callback) {
        this.send(HttpMethod.POST, callback, newTeamwork);
    }

    @Override
    public Teamwork post(Teamwork newTeamwork) throws ClientException {
        return (Teamwork)this.send(HttpMethod.POST, newTeamwork);
    }

    @Override
    public ITeamworkRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamworkRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

