/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.CallMediaState;
import com.microsoft.graph.models.extensions.CallOptions;
import com.microsoft.graph.models.extensions.CallRoute;
import com.microsoft.graph.models.extensions.CallTranscriptionInfo;
import com.microsoft.graph.models.extensions.ChatInfo;
import com.microsoft.graph.models.extensions.CommsOperation;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.IncomingContext;
import com.microsoft.graph.models.extensions.InvitationParticipantInfo;
import com.microsoft.graph.models.extensions.MediaConfig;
import com.microsoft.graph.models.extensions.MeetingInfo;
import com.microsoft.graph.models.extensions.Participant;
import com.microsoft.graph.models.extensions.ParticipantInfo;
import com.microsoft.graph.models.extensions.ResultInfo;
import com.microsoft.graph.models.extensions.ToneInfo;
import com.microsoft.graph.models.generated.CallDirection;
import com.microsoft.graph.models.generated.CallState;
import com.microsoft.graph.models.generated.Modality;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionPage;
import com.microsoft.graph.requests.extensions.CommsOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.ParticipantCollectionPage;
import com.microsoft.graph.requests.extensions.ParticipantCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;
import java.util.List;

public class Call
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="state")
    @Expose
    public CallState state;
    @SerializedName(value="mediaState")
    @Expose
    public CallMediaState mediaState;
    @SerializedName(value="resultInfo")
    @Expose
    public ResultInfo resultInfo;
    @SerializedName(value="direction")
    @Expose
    public CallDirection direction;
    @SerializedName(value="subject")
    @Expose
    public String subject;
    @SerializedName(value="callbackUri")
    @Expose
    public String callbackUri;
    @SerializedName(value="callRoutes")
    @Expose
    public List<CallRoute> callRoutes;
    @SerializedName(value="source")
    @Expose
    public ParticipantInfo source;
    @SerializedName(value="targets")
    @Expose
    public List<InvitationParticipantInfo> targets;
    @SerializedName(value="requestedModalities")
    @Expose
    public List<Modality> requestedModalities;
    @SerializedName(value="mediaConfig")
    @Expose
    public MediaConfig mediaConfig;
    @SerializedName(value="chatInfo")
    @Expose
    public ChatInfo chatInfo;
    @SerializedName(value="callOptions")
    @Expose
    public CallOptions callOptions;
    @SerializedName(value="meetingInfo")
    @Expose
    public MeetingInfo meetingInfo;
    @SerializedName(value="transcription")
    @Expose
    public CallTranscriptionInfo transcription;
    @SerializedName(value="tenantId")
    @Expose
    public String tenantId;
    @SerializedName(value="myParticipantId")
    @Expose
    public String myParticipantId;
    @SerializedName(value="toneInfo")
    @Expose
    public ToneInfo toneInfo;
    @SerializedName(value="callChainId")
    @Expose
    public String callChainId;
    @SerializedName(value="incomingContext")
    @Expose
    public IncomingContext incomingContext;
    public ParticipantCollectionPage participants;
    public CommsOperationCollectionPage operations;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Entity[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("participants")) {
            response = new ParticipantCollectionResponse();
            if (json.has("participants@odata.nextLink")) {
                response.nextLink = json.get("participants@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("participants").toString(), JsonObject[].class);
            array = new Participant[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Participant.class);
                ((Participant)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.participants = new ParticipantCollectionPage((ParticipantCollectionResponse)response, null);
        }
        if (json.has("operations")) {
            response = new CommsOperationCollectionResponse();
            if (json.has("operations@odata.nextLink")) {
                ((CommsOperationCollectionResponse)response).nextLink = json.get("operations@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("operations").toString(), JsonObject[].class);
            array = new CommsOperation[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), CommsOperation.class);
                ((CommsOperation)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((CommsOperationCollectionResponse)response).value = Arrays.asList(array);
            this.operations = new CommsOperationCollectionPage((CommsOperationCollectionResponse)response, null);
        }
    }
}

