// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.SubscribedSku;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISubscribedSkuRequestBuilder;
import com.microsoft.graph.requests.extensions.ISubscribedSkuCollectionRequest;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subscribed Sku Collection Request Builder.
 */
public class SubscribedSkuCollectionRequestBuilder extends BaseRequestBuilder implements ISubscribedSkuCollectionRequestBuilder {

    /**
     * The request builder for this collection of SubscribedSku
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SubscribedSkuCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public ISubscribedSkuCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public ISubscribedSkuCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new SubscribedSkuCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public ISubscribedSkuRequestBuilder byId(final String id) {
        return new SubscribedSkuRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
