// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.EventMessageRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Event Message Request Request.
 */
public interface IEventMessageRequestRequest extends IHttpRequest {

    /**
     * Gets the EventMessageRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<EventMessageRequest> callback);

    /**
     * Gets the EventMessageRequest from the service
     *
     * @return the EventMessageRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EventMessageRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<EventMessageRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this EventMessageRequest with a source
     *
     * @param sourceEventMessageRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final EventMessageRequest sourceEventMessageRequest, final ICallback<EventMessageRequest> callback);

    /**
     * Patches this EventMessageRequest with a source
     *
     * @param sourceEventMessageRequest the source object with updates
     * @return the updated EventMessageRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EventMessageRequest patch(final EventMessageRequest sourceEventMessageRequest) throws ClientException;

    /**
     * Posts a EventMessageRequest with a new object
     *
     * @param newEventMessageRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final EventMessageRequest newEventMessageRequest, final ICallback<EventMessageRequest> callback);

    /**
     * Posts a EventMessageRequest with a new object
     *
     * @param newEventMessageRequest the new object to create
     * @return the created EventMessageRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    EventMessageRequest post(final EventMessageRequest newEventMessageRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEventMessageRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEventMessageRequestRequest expand(final String value);

}

