// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDirectoryObjectRestoreRequest;
import com.microsoft.graph.requests.extensions.DirectoryObjectRestoreRequest;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Restore Request Builder.
 */
public class DirectoryObjectRestoreRequestBuilder extends BaseActionRequestBuilder implements IDirectoryObjectRestoreRequestBuilder {

    /**
     * The request builder for this DirectoryObjectRestore
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryObjectRestoreRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IDirectoryObjectRestoreRequest
     *
     * @return the IDirectoryObjectRestoreRequest instance
     */
    public IDirectoryObjectRestoreRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDirectoryObjectRestoreRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IDirectoryObjectRestoreRequest instance
     */
    public IDirectoryObjectRestoreRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        DirectoryObjectRestoreRequest request = new DirectoryObjectRestoreRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
