// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.CertificateBasedAuthConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Certificate Based Auth Configuration Request.
 */
public class CertificateBasedAuthConfigurationRequest extends BaseRequest implements ICertificateBasedAuthConfigurationRequest {
	
    /**
     * The request for the CertificateBasedAuthConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CertificateBasedAuthConfigurationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, CertificateBasedAuthConfiguration.class);
    }

    /**
     * Gets the CertificateBasedAuthConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<CertificateBasedAuthConfiguration> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the CertificateBasedAuthConfiguration from the service
     *
     * @return the CertificateBasedAuthConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public CertificateBasedAuthConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<CertificateBasedAuthConfiguration> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this CertificateBasedAuthConfiguration with a source
     *
     * @param sourceCertificateBasedAuthConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final CertificateBasedAuthConfiguration sourceCertificateBasedAuthConfiguration, final ICallback<CertificateBasedAuthConfiguration> callback) {
        send(HttpMethod.PATCH, callback, sourceCertificateBasedAuthConfiguration);
    }

    /**
     * Patches this CertificateBasedAuthConfiguration with a source
     *
     * @param sourceCertificateBasedAuthConfiguration the source object with updates
     * @return the updated CertificateBasedAuthConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public CertificateBasedAuthConfiguration patch(final CertificateBasedAuthConfiguration sourceCertificateBasedAuthConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration, final ICallback<CertificateBasedAuthConfiguration> callback) {
        send(HttpMethod.POST, callback, newCertificateBasedAuthConfiguration);
    }

    /**
     * Creates a CertificateBasedAuthConfiguration with a new object
     *
     * @param newCertificateBasedAuthConfiguration the new object to create
     * @return the created CertificateBasedAuthConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public CertificateBasedAuthConfiguration post(final CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) throws ClientException {
        return send(HttpMethod.POST, newCertificateBasedAuthConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ICertificateBasedAuthConfigurationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (CertificateBasedAuthConfigurationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ICertificateBasedAuthConfigurationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (CertificateBasedAuthConfigurationRequest)this;
     }

}

