// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.OperationStatus;
import com.microsoft.graph.models.extensions.Shift;
import com.microsoft.graph.models.extensions.OpenShift;
import com.microsoft.graph.models.extensions.TimeOff;
import com.microsoft.graph.models.extensions.TimeOffReason;
import com.microsoft.graph.models.extensions.SchedulingGroup;
import com.microsoft.graph.models.extensions.SwapShiftsChangeRequest;
import com.microsoft.graph.models.extensions.OpenShiftChangeRequest;
import com.microsoft.graph.models.extensions.OfferShiftRequest;
import com.microsoft.graph.models.extensions.TimeOffRequest;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ShiftCollectionResponse;
import com.microsoft.graph.requests.extensions.ShiftCollectionPage;
import com.microsoft.graph.requests.extensions.OpenShiftCollectionResponse;
import com.microsoft.graph.requests.extensions.OpenShiftCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffReasonCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffReasonCollectionPage;
import com.microsoft.graph.requests.extensions.SchedulingGroupCollectionResponse;
import com.microsoft.graph.requests.extensions.SchedulingGroupCollectionPage;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.SwapShiftsChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.OpenShiftChangeRequestCollectionPage;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.OfferShiftRequestCollectionPage;
import com.microsoft.graph.requests.extensions.TimeOffRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.TimeOffRequestCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule.
 */
public class Schedule extends Entity implements IJsonBackedObject {


    /**
     * The Enabled.
     * Indicates whether the schedule is enabled for the team. Required.
     */
    @SerializedName("enabled")
    @Expose
    public Boolean enabled;

    /**
     * The Time Zone.
     * Indicates the time zone of the schedule team using tz database format. Required.
     */
    @SerializedName("timeZone")
    @Expose
    public String timeZone;

    /**
     * The Provision Status.
     * The status of the schedule provisioning. The possible values are notStarted, running, completed, failed.
     */
    @SerializedName("provisionStatus")
    @Expose
    public OperationStatus provisionStatus;

    /**
     * The Provision Status Code.
     * Additional information about why schedule provisioning failed.
     */
    @SerializedName("provisionStatusCode")
    @Expose
    public String provisionStatusCode;

    /**
     * The Workforce Integration Ids.
     * 
     */
    @SerializedName("workforceIntegrationIds")
    @Expose
    public java.util.List<String> workforceIntegrationIds;

    /**
     * The Time Clock Enabled.
     * Indicates whether time clock is enabled for the schedule.
     */
    @SerializedName("timeClockEnabled")
    @Expose
    public Boolean timeClockEnabled;

    /**
     * The Open Shifts Enabled.
     * Indicates whether open shifts are enabled for the schedule.
     */
    @SerializedName("openShiftsEnabled")
    @Expose
    public Boolean openShiftsEnabled;

    /**
     * The Swap Shifts Requests Enabled.
     * Indicates whether swap shifts requests are enabled for the schedule.
     */
    @SerializedName("swapShiftsRequestsEnabled")
    @Expose
    public Boolean swapShiftsRequestsEnabled;

    /**
     * The Offer Shift Requests Enabled.
     * Indicates whether offer shift requests are enabled for the schedule.
     */
    @SerializedName("offerShiftRequestsEnabled")
    @Expose
    public Boolean offerShiftRequestsEnabled;

    /**
     * The Time Off Requests Enabled.
     * Indicates whether time off requests are enabled for the schedule.
     */
    @SerializedName("timeOffRequestsEnabled")
    @Expose
    public Boolean timeOffRequestsEnabled;

    /**
     * The Shifts.
     * The shifts in the schedule.
     */
    public ShiftCollectionPage shifts;

    /**
     * The Open Shifts.
     * 
     */
    public OpenShiftCollectionPage openShifts;

    /**
     * The Times Off.
     * The instances of times off in the schedule.
     */
    public TimeOffCollectionPage timesOff;

    /**
     * The Time Off Reasons.
     * The set of reasons for a time off in the schedule.
     */
    public TimeOffReasonCollectionPage timeOffReasons;

    /**
     * The Scheduling Groups.
     * The logical grouping of users in the schedule (usually by role).
     */
    public SchedulingGroupCollectionPage schedulingGroups;

    /**
     * The Swap Shifts Change Requests.
     * 
     */
    public SwapShiftsChangeRequestCollectionPage swapShiftsChangeRequests;

    /**
     * The Open Shift Change Requests.
     * 
     */
    public OpenShiftChangeRequestCollectionPage openShiftChangeRequests;

    /**
     * The Offer Shift Requests.
     * 
     */
    public OfferShiftRequestCollectionPage offerShiftRequests;

    /**
     * The Time Off Requests.
     * 
     */
    public TimeOffRequestCollectionPage timeOffRequests;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("shifts")) {
            final ShiftCollectionResponse response = new ShiftCollectionResponse();
            if (json.has("shifts@odata.nextLink")) {
                response.nextLink = json.get("shifts@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("shifts").toString(), JsonObject[].class);
            final Shift[] array = new Shift[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), Shift.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            shifts = new ShiftCollectionPage(response, null);
        }

        if (json.has("openShifts")) {
            final OpenShiftCollectionResponse response = new OpenShiftCollectionResponse();
            if (json.has("openShifts@odata.nextLink")) {
                response.nextLink = json.get("openShifts@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("openShifts").toString(), JsonObject[].class);
            final OpenShift[] array = new OpenShift[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), OpenShift.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            openShifts = new OpenShiftCollectionPage(response, null);
        }

        if (json.has("timesOff")) {
            final TimeOffCollectionResponse response = new TimeOffCollectionResponse();
            if (json.has("timesOff@odata.nextLink")) {
                response.nextLink = json.get("timesOff@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("timesOff").toString(), JsonObject[].class);
            final TimeOff[] array = new TimeOff[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TimeOff.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            timesOff = new TimeOffCollectionPage(response, null);
        }

        if (json.has("timeOffReasons")) {
            final TimeOffReasonCollectionResponse response = new TimeOffReasonCollectionResponse();
            if (json.has("timeOffReasons@odata.nextLink")) {
                response.nextLink = json.get("timeOffReasons@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("timeOffReasons").toString(), JsonObject[].class);
            final TimeOffReason[] array = new TimeOffReason[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TimeOffReason.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            timeOffReasons = new TimeOffReasonCollectionPage(response, null);
        }

        if (json.has("schedulingGroups")) {
            final SchedulingGroupCollectionResponse response = new SchedulingGroupCollectionResponse();
            if (json.has("schedulingGroups@odata.nextLink")) {
                response.nextLink = json.get("schedulingGroups@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("schedulingGroups").toString(), JsonObject[].class);
            final SchedulingGroup[] array = new SchedulingGroup[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SchedulingGroup.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            schedulingGroups = new SchedulingGroupCollectionPage(response, null);
        }

        if (json.has("swapShiftsChangeRequests")) {
            final SwapShiftsChangeRequestCollectionResponse response = new SwapShiftsChangeRequestCollectionResponse();
            if (json.has("swapShiftsChangeRequests@odata.nextLink")) {
                response.nextLink = json.get("swapShiftsChangeRequests@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("swapShiftsChangeRequests").toString(), JsonObject[].class);
            final SwapShiftsChangeRequest[] array = new SwapShiftsChangeRequest[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), SwapShiftsChangeRequest.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            swapShiftsChangeRequests = new SwapShiftsChangeRequestCollectionPage(response, null);
        }

        if (json.has("openShiftChangeRequests")) {
            final OpenShiftChangeRequestCollectionResponse response = new OpenShiftChangeRequestCollectionResponse();
            if (json.has("openShiftChangeRequests@odata.nextLink")) {
                response.nextLink = json.get("openShiftChangeRequests@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("openShiftChangeRequests").toString(), JsonObject[].class);
            final OpenShiftChangeRequest[] array = new OpenShiftChangeRequest[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), OpenShiftChangeRequest.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            openShiftChangeRequests = new OpenShiftChangeRequestCollectionPage(response, null);
        }

        if (json.has("offerShiftRequests")) {
            final OfferShiftRequestCollectionResponse response = new OfferShiftRequestCollectionResponse();
            if (json.has("offerShiftRequests@odata.nextLink")) {
                response.nextLink = json.get("offerShiftRequests@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("offerShiftRequests").toString(), JsonObject[].class);
            final OfferShiftRequest[] array = new OfferShiftRequest[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), OfferShiftRequest.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            offerShiftRequests = new OfferShiftRequestCollectionPage(response, null);
        }

        if (json.has("timeOffRequests")) {
            final TimeOffRequestCollectionResponse response = new TimeOffRequestCollectionResponse();
            if (json.has("timeOffRequests@odata.nextLink")) {
                response.nextLink = json.get("timeOffRequests@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("timeOffRequests").toString(), JsonObject[].class);
            final TimeOffRequest[] array = new TimeOffRequest[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), TimeOffRequest.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            timeOffRequests = new TimeOffRequestCollectionPage(response, null);
        }
    }
}
