// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ApplicationEnforcedRestrictionsSessionControl;
import com.microsoft.graph.models.extensions.CloudAppSecuritySessionControl;
import com.microsoft.graph.models.extensions.SignInFrequencySessionControl;
import com.microsoft.graph.models.extensions.PersistentBrowserSessionControl;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Session Controls.
 */
public class ConditionalAccessSessionControls implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Application Enforced Restrictions.
     * Session control to enforce application restrictions. Only Exchange Online and Sharepoint Online support this session control.
     */
    @SerializedName("applicationEnforcedRestrictions")
    @Expose
    public ApplicationEnforcedRestrictionsSessionControl applicationEnforcedRestrictions;

    /**
     * The Cloud App Security.
     * Session control to apply cloud app security.
     */
    @SerializedName("cloudAppSecurity")
    @Expose
    public CloudAppSecuritySessionControl cloudAppSecurity;

    /**
     * The Sign In Frequency.
     * Session control to enforce signin frequency.
     */
    @SerializedName("signInFrequency")
    @Expose
    public SignInFrequencySessionControl signInFrequency;

    /**
     * The Persistent Browser.
     * Session control to define whether to persist cookies or not. All apps should be selected for this session control to work correctly.
     */
    @SerializedName("persistentBrowser")
    @Expose
    public PersistentBrowserSessionControl persistentBrowser;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
