// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookChartFillRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartFillRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartFillClearRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartFillClearRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartFillSetSolidColorRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartFillSetSolidColorRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Fill Request Builder.
 */
public class WorkbookChartFillRequestBuilder extends BaseRequestBuilder implements IWorkbookChartFillRequestBuilder {

    /**
     * The request builder for the WorkbookChartFill
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartFillRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookChartFillRequest instance
     */
    public IWorkbookChartFillRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartFillRequest instance
     */
    public IWorkbookChartFillRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookChartFillRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IWorkbookChartFillClearRequestBuilder clear() {
        return new WorkbookChartFillClearRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.clear"), getClient(), null);
    }

    public IWorkbookChartFillSetSolidColorRequestBuilder setSolidColor(final String color) {
        return new WorkbookChartFillSetSolidColorRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.setSolidColor"), getClient(), null, color);
    }
}

