// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission Grant Collection Request.
 */
public class PermissionGrantCollectionRequest extends BaseCollectionRequest<PermissionGrantCollectionResponse, IPermissionGrantCollectionPage> implements IPermissionGrantCollectionRequest {


    protected final PermissionGrantBody body;


    /**
     * The request for this PermissionGrant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PermissionGrantCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PermissionGrantCollectionResponse.class, IPermissionGrantCollectionPage.class);
        body = new PermissionGrantBody();
    }


    public void post(final ICallback<IPermissionGrantCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(post(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IPermissionGrantCollectionPage post() throws ClientException {
        final PermissionGrantCollectionResponse response = post(body);
        return buildFromResponse(response);
    }


    public IPermissionGrantCollectionPage buildFromResponse(final PermissionGrantCollectionResponse response) {
        final IPermissionGrantCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new PermissionGrantCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, /* roles */ null, /* recipients */ null);
        } else {
            builder = null;
        }
        final IPermissionGrantCollectionPage page = new PermissionGrantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IPermissionGrantCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IPermissionGrantCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (IPermissionGrantCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IPermissionGrantCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IPermissionGrantCollectionRequest)this;
    }

}
