// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IParticipantInviteRequest;
import com.microsoft.graph.requests.extensions.ParticipantInviteRequest;
import com.microsoft.graph.models.extensions.InvitationParticipantInfo;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Participant Invite Request Builder.
 */
public class ParticipantInviteRequestBuilder extends BaseActionRequestBuilder implements IParticipantInviteRequestBuilder {

    /**
     * The request builder for this ParticipantInvite
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param participants the participants
     * @param clientContext the clientContext
     */
    public ParticipantInviteRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final java.util.List<InvitationParticipantInfo> participants, final String clientContext) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("participants", participants);
        bodyParams.put("clientContext", clientContext);
    }

    /**
     * Creates the IParticipantInviteRequest
     *
     * @return the IParticipantInviteRequest instance
     */
    public IParticipantInviteRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IParticipantInviteRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IParticipantInviteRequest instance
     */
    public IParticipantInviteRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        ParticipantInviteRequest request = new ParticipantInviteRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("participants")) {
            request.body.participants = getParameter("participants");
        }

        if (hasParameter("clientContext")) {
            request.body.clientContext = getParameter("clientContext");
        }

        return request;
    }
}
