// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.RoleDefinition;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Role Definition Request.
 */
public interface IRoleDefinitionRequest extends IHttpRequest {

    /**
     * Gets the RoleDefinition from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<RoleDefinition> callback);

    /**
     * Gets the RoleDefinition from the service
     *
     * @return the RoleDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    RoleDefinition get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<RoleDefinition> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this RoleDefinition with a source
     *
     * @param sourceRoleDefinition the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final RoleDefinition sourceRoleDefinition, final ICallback<RoleDefinition> callback);

    /**
     * Patches this RoleDefinition with a source
     *
     * @param sourceRoleDefinition the source object with updates
     * @return the updated RoleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    RoleDefinition patch(final RoleDefinition sourceRoleDefinition) throws ClientException;

    /**
     * Posts a RoleDefinition with a new object
     *
     * @param newRoleDefinition the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final RoleDefinition newRoleDefinition, final ICallback<RoleDefinition> callback);

    /**
     * Posts a RoleDefinition with a new object
     *
     * @param newRoleDefinition the new object to create
     * @return the created RoleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    RoleDefinition post(final RoleDefinition newRoleDefinition) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IRoleDefinitionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IRoleDefinitionRequest expand(final String value);

}

