// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the App Role Assignment Collection Request.
 */
public class AppRoleAssignmentCollectionRequest extends BaseCollectionRequest<AppRoleAssignmentCollectionResponse, IAppRoleAssignmentCollectionPage> implements IAppRoleAssignmentCollectionRequest {

    /**
     * The request builder for this collection of AppRoleAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AppRoleAssignmentCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AppRoleAssignmentCollectionResponse.class, IAppRoleAssignmentCollectionPage.class);
    }

    public void get(final ICallback<IAppRoleAssignmentCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IAppRoleAssignmentCollectionPage get() throws ClientException {
        final AppRoleAssignmentCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final AppRoleAssignment newAppRoleAssignment, final ICallback<AppRoleAssignment> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new AppRoleAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newAppRoleAssignment, callback);
    }

    public AppRoleAssignment post(final AppRoleAssignment newAppRoleAssignment) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new AppRoleAssignmentRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newAppRoleAssignment);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IAppRoleAssignmentCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (AppRoleAssignmentCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IAppRoleAssignmentCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (AppRoleAssignmentCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IAppRoleAssignmentCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (AppRoleAssignmentCollectionRequest)this;
    }

    public IAppRoleAssignmentCollectionPage buildFromResponse(final AppRoleAssignmentCollectionResponse response) {
        final IAppRoleAssignmentCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new AppRoleAssignmentCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final AppRoleAssignmentCollectionPage page = new AppRoleAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
