// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.RgbColor;
import com.microsoft.graph.models.extensions.MimeContent;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Intune Brand.
 */
public class IntuneBrand implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Display Name.
     * Company/organization name that is displayed to end users.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Theme Color.
     * Primary theme color used in the Company Portal applications and web portal.
     */
    @SerializedName("themeColor")
    @Expose
    public RgbColor themeColor;

    /**
     * The Show Logo.
     * Boolean that represents whether the administrator-supplied logo images are shown or not shown.
     */
    @SerializedName("showLogo")
    @Expose
    public Boolean showLogo;

    /**
     * The Light Background Logo.
     * Logo image displayed in Company Portal apps which have a light background behind the logo.
     */
    @SerializedName("lightBackgroundLogo")
    @Expose
    public MimeContent lightBackgroundLogo;

    /**
     * The Dark Background Logo.
     * Logo image displayed in Company Portal apps which have a dark background behind the logo.
     */
    @SerializedName("darkBackgroundLogo")
    @Expose
    public MimeContent darkBackgroundLogo;

    /**
     * The Show Name Next To Logo.
     * Boolean that represents whether the administrator-supplied display name will be shown next to the logo image.
     */
    @SerializedName("showNameNextToLogo")
    @Expose
    public Boolean showNameNextToLogo;

    /**
     * The Show Display Name Next To Logo.
     * Boolean that represents whether the administrator-supplied display name will be shown next to the logo image.
     */
    @SerializedName("showDisplayNameNextToLogo")
    @Expose
    public Boolean showDisplayNameNextToLogo;

    /**
     * The Contact ITName.
     * Name of the person/organization responsible for IT support.
     */
    @SerializedName("contactITName")
    @Expose
    public String contactITName;

    /**
     * The Contact ITPhone Number.
     * Phone number of the person/organization responsible for IT support.
     */
    @SerializedName("contactITPhoneNumber")
    @Expose
    public String contactITPhoneNumber;

    /**
     * The Contact ITEmail Address.
     * Email address of the person/organization responsible for IT support.
     */
    @SerializedName("contactITEmailAddress")
    @Expose
    public String contactITEmailAddress;

    /**
     * The Contact ITNotes.
     * Text comments regarding the person/organization responsible for IT support.
     */
    @SerializedName("contactITNotes")
    @Expose
    public String contactITNotes;

    /**
     * The Online Support Site Url.
     * URL to the company/organization’s IT helpdesk site.
     */
    @SerializedName("onlineSupportSiteUrl")
    @Expose
    public String onlineSupportSiteUrl;

    /**
     * The Online Support Site Name.
     * Display name of the company/organization’s IT helpdesk site.
     */
    @SerializedName("onlineSupportSiteName")
    @Expose
    public String onlineSupportSiteName;

    /**
     * The Privacy Url.
     * URL to the company/organization’s privacy policy.
     */
    @SerializedName("privacyUrl")
    @Expose
    public String privacyUrl;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
