// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.OnenoteUserRole;
import com.microsoft.graph.models.extensions.NotebookLinks;
import com.microsoft.graph.models.extensions.IdentitySet;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Copy Notebook Model.
 */
public class CopyNotebookModel implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Is Default.
     * 
     */
    @SerializedName("isDefault")
    @Expose
    public Boolean isDefault;

    /**
     * The User Role.
     * 
     */
    @SerializedName("userRole")
    @Expose
    public OnenoteUserRole userRole;

    /**
     * The Is Shared.
     * 
     */
    @SerializedName("isShared")
    @Expose
    public Boolean isShared;

    /**
     * The Sections Url.
     * 
     */
    @SerializedName("sectionsUrl")
    @Expose
    public String sectionsUrl;

    /**
     * The Section Groups Url.
     * 
     */
    @SerializedName("sectionGroupsUrl")
    @Expose
    public String sectionGroupsUrl;

    /**
     * The Links.
     * 
     */
    @SerializedName("links")
    @Expose
    public NotebookLinks links;

    /**
     * The Name.
     * 
     */
    @SerializedName("name")
    @Expose
    public String name;

    /**
     * The Created By.
     * 
     */
    @SerializedName("createdBy")
    @Expose
    public String createdBy;

    /**
     * The Created By Identity.
     * 
     */
    @SerializedName("createdByIdentity")
    @Expose
    public IdentitySet createdByIdentity;

    /**
     * The Last Modified By.
     * 
     */
    @SerializedName("lastModifiedBy")
    @Expose
    public String lastModifiedBy;

    /**
     * The Last Modified By Identity.
     * 
     */
    @SerializedName("lastModifiedByIdentity")
    @Expose
    public IdentitySet lastModifiedByIdentity;

    /**
     * The Last Modified Time.
     * 
     */
    @SerializedName("lastModifiedTime")
    @Expose
    public java.util.Calendar lastModifiedTime;

    /**
     * The Id.
     * 
     */
    @SerializedName("id")
    @Expose
    public String id;

    /**
     * The Self.
     * 
     */
    @SerializedName("self")
    @Expose
    public String self;

    /**
     * The Created Time.
     * 
     */
    @SerializedName("createdTime")
    @Expose
    public java.util.Calendar createdTime;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
