// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection App Locker File Collection Request.
 */
public class WindowsInformationProtectionAppLockerFileCollectionRequest extends BaseCollectionRequest<WindowsInformationProtectionAppLockerFileCollectionResponse, IWindowsInformationProtectionAppLockerFileCollectionPage> implements IWindowsInformationProtectionAppLockerFileCollectionRequest {

    /**
     * The request builder for this collection of WindowsInformationProtectionAppLockerFile
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsInformationProtectionAppLockerFileCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionAppLockerFileCollectionResponse.class, IWindowsInformationProtectionAppLockerFileCollectionPage.class);
    }

    public void get(final ICallback<IWindowsInformationProtectionAppLockerFileCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IWindowsInformationProtectionAppLockerFileCollectionPage get() throws ClientException {
        final WindowsInformationProtectionAppLockerFileCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final WindowsInformationProtectionAppLockerFile newWindowsInformationProtectionAppLockerFile, final ICallback<WindowsInformationProtectionAppLockerFile> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new WindowsInformationProtectionAppLockerFileRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newWindowsInformationProtectionAppLockerFile, callback);
    }

    public WindowsInformationProtectionAppLockerFile post(final WindowsInformationProtectionAppLockerFile newWindowsInformationProtectionAppLockerFile) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new WindowsInformationProtectionAppLockerFileRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newWindowsInformationProtectionAppLockerFile);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IWindowsInformationProtectionAppLockerFileCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (WindowsInformationProtectionAppLockerFileCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IWindowsInformationProtectionAppLockerFileCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (WindowsInformationProtectionAppLockerFileCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IWindowsInformationProtectionAppLockerFileCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (WindowsInformationProtectionAppLockerFileCollectionRequest)this;
    }

    public IWindowsInformationProtectionAppLockerFileCollectionPage buildFromResponse(final WindowsInformationProtectionAppLockerFileCollectionResponse response) {
        final IWindowsInformationProtectionAppLockerFileCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new WindowsInformationProtectionAppLockerFileCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final WindowsInformationProtectionAppLockerFileCollectionPage page = new WindowsInformationProtectionAppLockerFileCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
