// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Terms And Conditions Assignment Collection Request Builder.
 */
public class TermsAndConditionsAssignmentCollectionRequestBuilder extends BaseRequestBuilder implements ITermsAndConditionsAssignmentCollectionRequestBuilder {

    /**
     * The request builder for this collection of TermsAndConditions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TermsAndConditionsAssignmentCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public ITermsAndConditionsAssignmentCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public ITermsAndConditionsAssignmentCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new TermsAndConditionsAssignmentCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public ITermsAndConditionsAssignmentRequestBuilder byId(final String id) {
        return new TermsAndConditionsAssignmentRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }


}
