// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IMailFolderRequest;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ISingleValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMultiValueLegacyExtendedPropertyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageRuleCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMessageRuleRequestBuilder;
import com.microsoft.graph.requests.extensions.IMailFolderCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IMailFolderRequestBuilder;
import com.microsoft.graph.requests.extensions.IMailFolderCopyRequestBuilder;
import com.microsoft.graph.requests.extensions.IMailFolderMoveRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Mail Folder Request Builder.
 */
public interface IMailFolderRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IMailFolderRequest instance
     */
    IMailFolderRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IMailFolderRequest instance
     */
    IMailFolderRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    ISingleValueLegacyExtendedPropertyCollectionRequestBuilder singleValueExtendedProperties();

    ISingleValueLegacyExtendedPropertyRequestBuilder singleValueExtendedProperties(final String id);

    IMultiValueLegacyExtendedPropertyCollectionRequestBuilder multiValueExtendedProperties();

    IMultiValueLegacyExtendedPropertyRequestBuilder multiValueExtendedProperties(final String id);

    IMessageCollectionRequestBuilder messages();

    IMessageRequestBuilder messages(final String id);

    IMessageRuleCollectionRequestBuilder messageRules();

    IMessageRuleRequestBuilder messageRules(final String id);

    IMailFolderCollectionRequestBuilder childFolders();

    IMailFolderRequestBuilder childFolders(final String id);
    IMailFolderCopyRequestBuilder copy(final String destinationId);
    IMailFolderMoveRequestBuilder move(final String destinationId);

}
