// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;

import com.microsoft.graph.models.generated.*;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.google.gson.JsonObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Get Schedule Body.
 */
public class CalendarGetScheduleBody {

    /**
     * The schedules.
     * 
     */
    @SerializedName("schedules")
    @Expose
    public java.util.List<String> schedules;

    /**
     * The end Time.
     * 
     */
    @SerializedName("endTime")
    @Expose
    public DateTimeTimeZone endTime;

    /**
     * The start Time.
     * 
     */
    @SerializedName("startTime")
    @Expose
    public DateTimeTimeZone startTime;

    /**
     * The availability View Interval.
     * 
     */
    @SerializedName("availabilityViewInterval")
    @Expose
    public Integer availabilityViewInterval;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
