/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveRecentCollectionPage;
import com.microsoft.graph.requests.extensions.DriveRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveRecentCollectionResponse;
import com.microsoft.graph.requests.extensions.IDriveRecentCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveRecentCollectionRequest;
import java.util.List;

public class DriveRecentCollectionRequest
extends BaseCollectionRequest<DriveRecentCollectionResponse, IDriveRecentCollectionPage>
implements IDriveRecentCollectionRequest {
    public DriveRecentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveRecentCollectionResponse.class, IDriveRecentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveRecentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveRecentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveRecentCollectionPage get() throws ClientException {
        DriveRecentCollectionResponse response = (DriveRecentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IDriveRecentCollectionPage buildFromResponse(DriveRecentCollectionResponse response) {
        DriveRecentCollectionRequestBuilder builder = response.nextLink != null ? new DriveRecentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveRecentCollectionPage page = new DriveRecentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveRecentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveRecentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveRecentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }
}

