// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxesRequest;
import com.microsoft.graph.requests.extensions.WorkbookChartAxesRequest;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxisRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartAxisRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxisRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartAxisRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxisRequestBuilder;
import com.microsoft.graph.requests.extensions.WorkbookChartAxisRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Axes Request Builder.
 */
public class WorkbookChartAxesRequestBuilder extends BaseRequestBuilder implements IWorkbookChartAxesRequestBuilder {

    /**
     * The request builder for the WorkbookChartAxes
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookChartAxesRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IWorkbookChartAxesRequest instance
     */
    public IWorkbookChartAxesRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartAxesRequest instance
     */
    public IWorkbookChartAxesRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new WorkbookChartAxesRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    public IWorkbookChartAxisRequestBuilder categoryAxis() {
        return new WorkbookChartAxisRequestBuilder(getRequestUrlWithAdditionalSegment("categoryAxis"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    public IWorkbookChartAxisRequestBuilder seriesAxis() {
        return new WorkbookChartAxisRequestBuilder(getRequestUrlWithAdditionalSegment("seriesAxis"), getClient(), null);
    }

    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    public IWorkbookChartAxisRequestBuilder valueAxis() {
        return new WorkbookChartAxisRequestBuilder(getRequestUrlWithAdditionalSegment("valueAxis"), getClient(), null);
    }
}

