// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IRoleDefinitionRequest;
import com.microsoft.graph.requests.extensions.RoleDefinitionRequest;
import com.microsoft.graph.models.extensions.RoleDefinition;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Role Definition Request.
 */
public class RoleDefinitionRequest extends BaseRequest implements IRoleDefinitionRequest {
	
    /**
     * The request for the RoleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public RoleDefinitionRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends Option> requestOptions,
            final Class<? extends RoleDefinition> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the RoleDefinition
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public RoleDefinitionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoleDefinition.class);
    }

    /**
     * Gets the RoleDefinition from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<RoleDefinition> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the RoleDefinition from the service
     *
     * @return the RoleDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RoleDefinition get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<RoleDefinition> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this RoleDefinition with a source
     *
     * @param sourceRoleDefinition the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final RoleDefinition sourceRoleDefinition, final ICallback<RoleDefinition> callback) {
        send(HttpMethod.PATCH, callback, sourceRoleDefinition);
    }

    /**
     * Patches this RoleDefinition with a source
     *
     * @param sourceRoleDefinition the source object with updates
     * @return the updated RoleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RoleDefinition patch(final RoleDefinition sourceRoleDefinition) throws ClientException {
        return send(HttpMethod.PATCH, sourceRoleDefinition);
    }

    /**
     * Creates a RoleDefinition with a new object
     *
     * @param newRoleDefinition the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final RoleDefinition newRoleDefinition, final ICallback<RoleDefinition> callback) {
        send(HttpMethod.POST, callback, newRoleDefinition);
    }

    /**
     * Creates a RoleDefinition with a new object
     *
     * @param newRoleDefinition the new object to create
     * @return the created RoleDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public RoleDefinition post(final RoleDefinition newRoleDefinition) throws ClientException {
        return send(HttpMethod.POST, newRoleDefinition);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IRoleDefinitionRequest select(final String value) {
         getQueryOptions().add(new QueryOption("$select", value));
         return (RoleDefinitionRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IRoleDefinitionRequest expand(final String value) {
         getQueryOptions().add(new QueryOption("$expand", value));
         return (RoleDefinitionRequest)this;
     }

}

