// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App Category Reference Request.
 */
public class MobileAppCategoryReferenceRequest extends BaseRequest implements IMobileAppCategoryReferenceRequest {

    /**
     * The request for the MobileAppCategory
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileAppCategoryReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileAppCategory.class);
    }

    public void delete(final ICallback<MobileAppCategory> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public MobileAppCategory delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IMobileAppCategoryReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (MobileAppCategoryReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IMobileAppCategoryReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (MobileAppCategoryReferenceRequest)this;
    }
    /**
     * Puts the MobileAppCategory
     *
     * @param srcMobileAppCategory the MobileAppCategory reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(MobileAppCategory srcMobileAppCategory, final ICallback<MobileAppCategory> callback) {
        send(HttpMethod.PUT, callback, srcMobileAppCategory);
    }

    /**
     * Puts the MobileAppCategory
     *
     * @param srcMobileAppCategory the MobileAppCategory reference to PUT
     * @return the MobileAppCategory
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public MobileAppCategory put(MobileAppCategory srcMobileAppCategory) throws ClientException {
        return send(HttpMethod.PUT, srcMobileAppCategory);
    }
}
